@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The encryption configuration for the account.
 * @property keyVaultMetaInfo The Key Vault information for connecting to user managed encryption keys.
 * @property type The type of encryption configuration being used. Currently the only supported types are 'UserManaged' and 'ServiceManaged'.
 */
public data class EncryptionConfigResponse(
    public val keyVaultMetaInfo: KeyVaultMetaInfoResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.outputs.EncryptionConfigResponse):
            EncryptionConfigResponse = EncryptionConfigResponse(
            keyVaultMetaInfo = javaType.keyVaultMetaInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datalakestore.kotlin.outputs.KeyVaultMetaInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
