@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The encryption identity properties.
 * @property principalId The principal identifier associated with the encryption.
 * @property tenantId The tenant identifier associated with the encryption.
 * @property type The type of encryption being used. Currently the only supported type is 'SystemAssigned'.
 */
public data class EncryptionIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.outputs.EncryptionIdentityResponse):
            EncryptionIdentityResponse = EncryptionIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
