@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseMigrationPropertiesSqlDbResponse
import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseMigrationPropertiesSqlDbResponse.Companion.toKotlin as databaseMigrationPropertiesSqlDbResponseToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DatabaseMigrationsSqlDb].
 */
@PulumiTagMarker
public class DatabaseMigrationsSqlDbResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseMigrationsSqlDbArgs = DatabaseMigrationsSqlDbArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabaseMigrationsSqlDbArgsBuilder.() -> Unit) {
        val builder = DatabaseMigrationsSqlDbArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DatabaseMigrationsSqlDb {
        val builtJavaResource =
            com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDb(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DatabaseMigrationsSqlDb(builtJavaResource)
    }
}

/**
 * Database Migration Resource for SQL Database.
 * Azure REST API version: 2022-03-30-preview. Prior API version in Azure Native 1.x: 2022-03-30-preview.
 * Other available API versions: 2023-07-15-preview.
 * ## Example Usage
 * ### Create or Update Database Migration resource with Maximum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseMigrationsSqlDb = new AzureNative.DataMigration.DatabaseMigrationsSqlDb("databaseMigrationsSqlDb", new()
 *     {
 *         Properties = new AzureNative.DataMigration.Inputs.DatabaseMigrationPropertiesSqlDbArgs
 *         {
 *             Kind = "SqlDb",
 *             MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent",
 *             Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance",
 *             SourceDatabaseName = "aaa",
 *             SourceSqlConnection = new AzureNative.DataMigration.Inputs.SqlConnectionInformationArgs
 *             {
 *                 Authentication = "WindowsAuthentication",
 *                 DataSource = "aaa",
 *                 EncryptConnection = true,
 *                 Password = "placeholder",
 *                 TrustServerCertificate = true,
 *                 UserName = "bbb",
 *             },
 *             TableList = new[]
 *             {
 *                 "[Schema1].[TableName1]",
 *                 "[Schema2].[TableName2]",
 *             },
 *             TargetSqlConnection = new AzureNative.DataMigration.Inputs.SqlConnectionInformationArgs
 *             {
 *                 Authentication = "SqlAuthentication",
 *                 DataSource = "sqldbinstance",
 *                 EncryptConnection = true,
 *                 Password = "placeholder",
 *                 TrustServerCertificate = true,
 *                 UserName = "bbb",
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         SqlDbInstanceName = "sqldbinstance",
 *         TargetDbName = "db1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewDatabaseMigrationsSqlDb(ctx, "databaseMigrationsSqlDb", &datamigration.DatabaseMigrationsSqlDbArgs{
 * 			Properties: &datamigration.DatabaseMigrationPropertiesSqlDbArgs{
 * 				Kind:               pulumi.String("SqlDb"),
 * 				MigrationService:   pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent"),
 * 				Scope:              pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance"),
 * 				SourceDatabaseName: pulumi.String("aaa"),
 * 				SourceSqlConnection: &datamigration.SqlConnectionInformationArgs{
 * 					Authentication:         pulumi.String("WindowsAuthentication"),
 * 					DataSource:             pulumi.String("aaa"),
 * 					EncryptConnection:      pulumi.Bool(true),
 * 					Password:               pulumi.String("placeholder"),
 * 					TrustServerCertificate: pulumi.Bool(true),
 * 					UserName:               pulumi.String("bbb"),
 * 				},
 * 				TableList: pulumi.StringArray{
 * 					pulumi.String("[Schema1].[TableName1]"),
 * 					pulumi.String("[Schema2].[TableName2]"),
 * 				},
 * 				TargetSqlConnection: &datamigration.SqlConnectionInformationArgs{
 * 					Authentication:         pulumi.String("SqlAuthentication"),
 * 					DataSource:             pulumi.String("sqldbinstance"),
 * 					EncryptConnection:      pulumi.Bool(true),
 * 					Password:               pulumi.String("placeholder"),
 * 					TrustServerCertificate: pulumi.Bool(true),
 * 					UserName:               pulumi.String("bbb"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			SqlDbInstanceName: pulumi.String("sqldbinstance"),
 * 			TargetDbName:      pulumi.String("db1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDb;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDbArgs;
 * import com.pulumi.azurenative.datamigration.inputs.DatabaseMigrationPropertiesSqlDbArgs;
 * import com.pulumi.azurenative.datamigration.inputs.SqlConnectionInformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseMigrationsSqlDb = new DatabaseMigrationsSqlDb("databaseMigrationsSqlDb", DatabaseMigrationsSqlDbArgs.builder()
 *             .properties(DatabaseMigrationPropertiesSqlDbArgs.builder()
 *                 .kind("SqlDb")
 *                 .migrationService("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent")
 *                 .scope("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance")
 *                 .sourceDatabaseName("aaa")
 *                 .sourceSqlConnection(SqlConnectionInformationArgs.builder()
 *                     .authentication("WindowsAuthentication")
 *                     .dataSource("aaa")
 *                     .encryptConnection(true)
 *                     .password("placeholder")
 *                     .trustServerCertificate(true)
 *                     .userName("bbb")
 *                     .build())
 *                 .tableList(
 *                     "[Schema1].[TableName1]",
 *                     "[Schema2].[TableName2]")
 *                 .targetSqlConnection(SqlConnectionInformationArgs.builder()
 *                     .authentication("SqlAuthentication")
 *                     .dataSource("sqldbinstance")
 *                     .encryptConnection(true)
 *                     .password("placeholder")
 *                     .trustServerCertificate(true)
 *                     .userName("bbb")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .sqlDbInstanceName("sqldbinstance")
 *             .targetDbName("db1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Database Migration resource with Minimum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseMigrationsSqlDb = new AzureNative.DataMigration.DatabaseMigrationsSqlDb("databaseMigrationsSqlDb", new()
 *     {
 *         Properties = new AzureNative.DataMigration.Inputs.DatabaseMigrationPropertiesSqlDbArgs
 *         {
 *             Kind = "SqlDb",
 *             MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent",
 *             Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance",
 *             SourceDatabaseName = "aaa",
 *             SourceSqlConnection = new AzureNative.DataMigration.Inputs.SqlConnectionInformationArgs
 *             {
 *                 Authentication = "WindowsAuthentication",
 *                 DataSource = "aaa",
 *                 EncryptConnection = true,
 *                 Password = "placeholder",
 *                 TrustServerCertificate = true,
 *                 UserName = "bbb",
 *             },
 *             TargetSqlConnection = new AzureNative.DataMigration.Inputs.SqlConnectionInformationArgs
 *             {
 *                 Authentication = "SqlAuthentication",
 *                 DataSource = "sqldbinstance",
 *                 EncryptConnection = true,
 *                 Password = "placeholder",
 *                 TrustServerCertificate = true,
 *                 UserName = "bbb",
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         SqlDbInstanceName = "sqldbinstance",
 *         TargetDbName = "db1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewDatabaseMigrationsSqlDb(ctx, "databaseMigrationsSqlDb", &datamigration.DatabaseMigrationsSqlDbArgs{
 * 			Properties: &datamigration.DatabaseMigrationPropertiesSqlDbArgs{
 * 				Kind:               pulumi.String("SqlDb"),
 * 				MigrationService:   pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent"),
 * 				Scope:              pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance"),
 * 				SourceDatabaseName: pulumi.String("aaa"),
 * 				SourceSqlConnection: &datamigration.SqlConnectionInformationArgs{
 * 					Authentication:         pulumi.String("WindowsAuthentication"),
 * 					DataSource:             pulumi.String("aaa"),
 * 					EncryptConnection:      pulumi.Bool(true),
 * 					Password:               pulumi.String("placeholder"),
 * 					TrustServerCertificate: pulumi.Bool(true),
 * 					UserName:               pulumi.String("bbb"),
 * 				},
 * 				TargetSqlConnection: &datamigration.SqlConnectionInformationArgs{
 * 					Authentication:         pulumi.String("SqlAuthentication"),
 * 					DataSource:             pulumi.String("sqldbinstance"),
 * 					EncryptConnection:      pulumi.Bool(true),
 * 					Password:               pulumi.String("placeholder"),
 * 					TrustServerCertificate: pulumi.Bool(true),
 * 					UserName:               pulumi.String("bbb"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			SqlDbInstanceName: pulumi.String("sqldbinstance"),
 * 			TargetDbName:      pulumi.String("db1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDb;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDbArgs;
 * import com.pulumi.azurenative.datamigration.inputs.DatabaseMigrationPropertiesSqlDbArgs;
 * import com.pulumi.azurenative.datamigration.inputs.SqlConnectionInformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseMigrationsSqlDb = new DatabaseMigrationsSqlDb("databaseMigrationsSqlDb", DatabaseMigrationsSqlDbArgs.builder()
 *             .properties(DatabaseMigrationPropertiesSqlDbArgs.builder()
 *                 .kind("SqlDb")
 *                 .migrationService("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent")
 *                 .scope("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance")
 *                 .sourceDatabaseName("aaa")
 *                 .sourceSqlConnection(SqlConnectionInformationArgs.builder()
 *                     .authentication("WindowsAuthentication")
 *                     .dataSource("aaa")
 *                     .encryptConnection(true)
 *                     .password("placeholder")
 *                     .trustServerCertificate(true)
 *                     .userName("bbb")
 *                     .build())
 *                 .targetSqlConnection(SqlConnectionInformationArgs.builder()
 *                     .authentication("SqlAuthentication")
 *                     .dataSource("sqldbinstance")
 *                     .encryptConnection(true)
 *                     .password("placeholder")
 *                     .trustServerCertificate(true)
 *                     .userName("bbb")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .sqlDbInstanceName("sqldbinstance")
 *             .targetDbName("db1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:DatabaseMigrationsSqlDb db1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}
 * ```
 */
public class DatabaseMigrationsSqlDb internal constructor(
    override val javaResource: com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDb,
) : KotlinCustomResource(javaResource, DatabaseMigrationsSqlDbMapper) {
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Database Migration Resource properties for SQL database.
     */
    public val properties: Output<DatabaseMigrationPropertiesSqlDbResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                databaseMigrationPropertiesSqlDbResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatabaseMigrationsSqlDbMapper : ResourceMapper<DatabaseMigrationsSqlDb> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDb::class == javaResource::class

    override fun map(javaResource: Resource): DatabaseMigrationsSqlDb =
        DatabaseMigrationsSqlDb(
            javaResource as
                com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDb,
        )
}

/**
 * @see [DatabaseMigrationsSqlDb].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DatabaseMigrationsSqlDb].
 */
public suspend fun databaseMigrationsSqlDb(
    name: String,
    block: suspend DatabaseMigrationsSqlDbResourceBuilder.() -> Unit,
): DatabaseMigrationsSqlDb {
    val builder = DatabaseMigrationsSqlDbResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DatabaseMigrationsSqlDb].
 * @param name The _unique_ name of the resulting resource.
 */
public fun databaseMigrationsSqlDb(name: String): DatabaseMigrationsSqlDb {
    val builder = DatabaseMigrationsSqlDbResourceBuilder()
    builder.name(name)
    return builder.build()
}
