@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Target Platform for the migration
 */
public enum class MySqlTargetPlatformType(
    public val javaValue: com.pulumi.azurenative.datamigration.enums.MySqlTargetPlatformType,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.enums.MySqlTargetPlatformType> {
    SqlServer(com.pulumi.azurenative.datamigration.enums.MySqlTargetPlatformType.SqlServer),
    AzureDbForMySQL(com.pulumi.azurenative.datamigration.enums.MySqlTargetPlatformType.AzureDbForMySQL),
    ;

    override fun toJava(): com.pulumi.azurenative.datamigration.enums.MySqlTargetPlatformType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.enums.MySqlTargetPlatformType):
            MySqlTargetPlatformType =
            MySqlTargetPlatformType.values().first { it.javaValue == javaType }
    }
}
