@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToSourceMySqlTaskInputArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.enums.MySqlTargetPlatformType
import com.pulumi.azurenative.datamigration.kotlin.enums.ServerLevelPermissionsGroup
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for the task that validates MySQL database connection
 * @property checkPermissionsGroup Permission group for validations
 * @property isOfflineMigration Flag for whether or not the migration is offline
 * @property sourceConnectionInfo Information for connecting to MySQL source
 * @property targetPlatform Target Platform for the migration
 */
public data class ConnectToSourceMySqlTaskInputArgs(
    public val checkPermissionsGroup: Output<Either<String, ServerLevelPermissionsGroup>>? = null,
    public val isOfflineMigration: Output<Boolean>? = null,
    public val sourceConnectionInfo: Output<MySqlConnectionInfoArgs>,
    public val targetPlatform: Output<Either<String, MySqlTargetPlatformType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToSourceMySqlTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToSourceMySqlTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToSourceMySqlTaskInputArgs.builder()
            .checkPermissionsGroup(
                checkPermissionsGroup?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .isOfflineMigration(isOfflineMigration?.applyValue({ args0 -> args0 }))
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetPlatform(
                targetPlatform?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectToSourceMySqlTaskInputArgs].
 */
@PulumiTagMarker
public class ConnectToSourceMySqlTaskInputArgsBuilder internal constructor() {
    private var checkPermissionsGroup: Output<Either<String, ServerLevelPermissionsGroup>>? = null

    private var isOfflineMigration: Output<Boolean>? = null

    private var sourceConnectionInfo: Output<MySqlConnectionInfoArgs>? = null

    private var targetPlatform: Output<Either<String, MySqlTargetPlatformType>>? = null

    /**
     * @param value Permission group for validations
     */
    @JvmName("nmfrcgfejdjgfayy")
    public suspend
    fun checkPermissionsGroup(`value`: Output<Either<String, ServerLevelPermissionsGroup>>) {
        this.checkPermissionsGroup = value
    }

    /**
     * @param value Flag for whether or not the migration is offline
     */
    @JvmName("xiiauntqqyjvnfgq")
    public suspend fun isOfflineMigration(`value`: Output<Boolean>) {
        this.isOfflineMigration = value
    }

    /**
     * @param value Information for connecting to MySQL source
     */
    @JvmName("ikhnecsqugaeabvo")
    public suspend fun sourceConnectionInfo(`value`: Output<MySqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Target Platform for the migration
     */
    @JvmName("upwslynqauiibarc")
    public suspend fun targetPlatform(`value`: Output<Either<String, MySqlTargetPlatformType>>) {
        this.targetPlatform = value
    }

    /**
     * @param value Permission group for validations
     */
    @JvmName("fpxokhvqhalhqynx")
    public suspend fun checkPermissionsGroup(`value`: Either<String, ServerLevelPermissionsGroup>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkPermissionsGroup = mapped
    }

    /**
     * @param value Permission group for validations
     */
    @JvmName("bydxyssjxjtclity")
    public fun checkPermissionsGroup(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerLevelPermissionsGroup>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkPermissionsGroup = mapped
    }

    /**
     * @param value Permission group for validations
     */
    @JvmName("qtlvlewbhwntfcfw")
    public fun checkPermissionsGroup(`value`: ServerLevelPermissionsGroup) {
        val toBeMapped = Either.ofRight<String, ServerLevelPermissionsGroup>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkPermissionsGroup = mapped
    }

    /**
     * @param value Flag for whether or not the migration is offline
     */
    @JvmName("ljsqbeohsbohdoev")
    public suspend fun isOfflineMigration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOfflineMigration = mapped
    }

    /**
     * @param value Information for connecting to MySQL source
     */
    @JvmName("ppfngcluigxtxofk")
    public suspend fun sourceConnectionInfo(`value`: MySqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to MySQL source
     */
    @JvmName("ojehlxgypuhgifej")
    public suspend
    fun sourceConnectionInfo(argument: suspend MySqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MySqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Target Platform for the migration
     */
    @JvmName("cracukxrsepejppq")
    public suspend fun targetPlatform(`value`: Either<String, MySqlTargetPlatformType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPlatform = mapped
    }

    /**
     * @param value Target Platform for the migration
     */
    @JvmName("ktrjlgmnkukghkto")
    public fun targetPlatform(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MySqlTargetPlatformType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetPlatform = mapped
    }

    /**
     * @param value Target Platform for the migration
     */
    @JvmName("adnonwqxoptryeop")
    public fun targetPlatform(`value`: MySqlTargetPlatformType) {
        val toBeMapped = Either.ofRight<String, MySqlTargetPlatformType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetPlatform = mapped
    }

    internal fun build(): ConnectToSourceMySqlTaskInputArgs = ConnectToSourceMySqlTaskInputArgs(
        checkPermissionsGroup = checkPermissionsGroup,
        isOfflineMigration = isOfflineMigration,
        sourceConnectionInfo = sourceConnectionInfo ?: throw
            PulumiNullFieldException("sourceConnectionInfo"),
        targetPlatform = targetPlatform,
    )
}
