@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToSourceSqlServerTaskInputArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.enums.ServerLevelPermissionsGroup
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for the task that validates connection to SQL Server and also validates source server requirements
 * @property checkPermissionsGroup Permission group for validations
 * @property collectAgentJobs Flag for whether to collect agent jobs from source server.
 * @property collectDatabases Flag for whether to collect databases from source server.
 * @property collectLogins Flag for whether to collect logins from source server.
 * @property collectTdeCertificateInfo Flag for whether to collect TDE Certificate names from source server.
 * @property sourceConnectionInfo Connection information for Source SQL Server
 * @property validateSsisCatalogOnly Flag for whether to validate SSIS catalog is reachable on the source server.
 */
public data class ConnectToSourceSqlServerTaskInputArgs(
    public val checkPermissionsGroup: Output<Either<String, ServerLevelPermissionsGroup>>? = null,
    public val collectAgentJobs: Output<Boolean>? = null,
    public val collectDatabases: Output<Boolean>? = null,
    public val collectLogins: Output<Boolean>? = null,
    public val collectTdeCertificateInfo: Output<Boolean>? = null,
    public val sourceConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val validateSsisCatalogOnly: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToSourceSqlServerTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToSourceSqlServerTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToSourceSqlServerTaskInputArgs.builder()
            .checkPermissionsGroup(
                checkPermissionsGroup?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .collectAgentJobs(collectAgentJobs?.applyValue({ args0 -> args0 }))
            .collectDatabases(collectDatabases?.applyValue({ args0 -> args0 }))
            .collectLogins(collectLogins?.applyValue({ args0 -> args0 }))
            .collectTdeCertificateInfo(collectTdeCertificateInfo?.applyValue({ args0 -> args0 }))
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .validateSsisCatalogOnly(validateSsisCatalogOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectToSourceSqlServerTaskInputArgs].
 */
@PulumiTagMarker
public class ConnectToSourceSqlServerTaskInputArgsBuilder internal constructor() {
    private var checkPermissionsGroup: Output<Either<String, ServerLevelPermissionsGroup>>? = null

    private var collectAgentJobs: Output<Boolean>? = null

    private var collectDatabases: Output<Boolean>? = null

    private var collectLogins: Output<Boolean>? = null

    private var collectTdeCertificateInfo: Output<Boolean>? = null

    private var sourceConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var validateSsisCatalogOnly: Output<Boolean>? = null

    /**
     * @param value Permission group for validations
     */
    @JvmName("msedlagxuguojogm")
    public suspend
    fun checkPermissionsGroup(`value`: Output<Either<String, ServerLevelPermissionsGroup>>) {
        this.checkPermissionsGroup = value
    }

    /**
     * @param value Flag for whether to collect agent jobs from source server.
     */
    @JvmName("rghirqaxspgahepf")
    public suspend fun collectAgentJobs(`value`: Output<Boolean>) {
        this.collectAgentJobs = value
    }

    /**
     * @param value Flag for whether to collect databases from source server.
     */
    @JvmName("dfegttksitncaahk")
    public suspend fun collectDatabases(`value`: Output<Boolean>) {
        this.collectDatabases = value
    }

    /**
     * @param value Flag for whether to collect logins from source server.
     */
    @JvmName("pbbhkfijrgdsojjo")
    public suspend fun collectLogins(`value`: Output<Boolean>) {
        this.collectLogins = value
    }

    /**
     * @param value Flag for whether to collect TDE Certificate names from source server.
     */
    @JvmName("bdteuxyjebalwexj")
    public suspend fun collectTdeCertificateInfo(`value`: Output<Boolean>) {
        this.collectTdeCertificateInfo = value
    }

    /**
     * @param value Connection information for Source SQL Server
     */
    @JvmName("btytidlapmsspbpf")
    public suspend fun sourceConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Flag for whether to validate SSIS catalog is reachable on the source server.
     */
    @JvmName("pyodjqlyaraisdce")
    public suspend fun validateSsisCatalogOnly(`value`: Output<Boolean>) {
        this.validateSsisCatalogOnly = value
    }

    /**
     * @param value Permission group for validations
     */
    @JvmName("dptluctejwgslufq")
    public suspend fun checkPermissionsGroup(`value`: Either<String, ServerLevelPermissionsGroup>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkPermissionsGroup = mapped
    }

    /**
     * @param value Permission group for validations
     */
    @JvmName("fdgfbtvmdxffridt")
    public fun checkPermissionsGroup(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerLevelPermissionsGroup>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkPermissionsGroup = mapped
    }

    /**
     * @param value Permission group for validations
     */
    @JvmName("wxfojqvrsdbslqcy")
    public fun checkPermissionsGroup(`value`: ServerLevelPermissionsGroup) {
        val toBeMapped = Either.ofRight<String, ServerLevelPermissionsGroup>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkPermissionsGroup = mapped
    }

    /**
     * @param value Flag for whether to collect agent jobs from source server.
     */
    @JvmName("mrcgfarpfuniufco")
    public suspend fun collectAgentJobs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectAgentJobs = mapped
    }

    /**
     * @param value Flag for whether to collect databases from source server.
     */
    @JvmName("prunagisldhhboki")
    public suspend fun collectDatabases(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectDatabases = mapped
    }

    /**
     * @param value Flag for whether to collect logins from source server.
     */
    @JvmName("eywxdymdcisandot")
    public suspend fun collectLogins(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectLogins = mapped
    }

    /**
     * @param value Flag for whether to collect TDE Certificate names from source server.
     */
    @JvmName("fenkyuxxnjhfcess")
    public suspend fun collectTdeCertificateInfo(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectTdeCertificateInfo = mapped
    }

    /**
     * @param value Connection information for Source SQL Server
     */
    @JvmName("blxobobwhksplbng")
    public suspend fun sourceConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for Source SQL Server
     */
    @JvmName("mwuxnkomqwtvlorh")
    public suspend
    fun sourceConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Flag for whether to validate SSIS catalog is reachable on the source server.
     */
    @JvmName("rbeyrehprrqvrbcj")
    public suspend fun validateSsisCatalogOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validateSsisCatalogOnly = mapped
    }

    internal fun build(): ConnectToSourceSqlServerTaskInputArgs =
        ConnectToSourceSqlServerTaskInputArgs(
            checkPermissionsGroup = checkPermissionsGroup,
            collectAgentJobs = collectAgentJobs,
            collectDatabases = collectDatabases,
            collectLogins = collectLogins,
            collectTdeCertificateInfo = collectTdeCertificateInfo,
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            validateSsisCatalogOnly = validateSsisCatalogOnly,
        )
}
