@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForMySqlTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for the task that validates connection to Azure Database for MySQL and target server requirements
 * @property isOfflineMigration Flag for whether or not the migration is offline
 * @property sourceConnectionInfo Connection information for source MySQL server
 * @property targetConnectionInfo Connection information for target Azure Database for MySQL server
 */
public data class ConnectToTargetAzureDbForMySqlTaskInputArgs(
    public val isOfflineMigration: Output<Boolean>? = null,
    public val sourceConnectionInfo: Output<MySqlConnectionInfoArgs>,
    public val targetConnectionInfo: Output<MySqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForMySqlTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForMySqlTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForMySqlTaskInputArgs.builder()
            .isOfflineMigration(isOfflineMigration?.applyValue({ args0 -> args0 }))
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectToTargetAzureDbForMySqlTaskInputArgs].
 */
@PulumiTagMarker
public class ConnectToTargetAzureDbForMySqlTaskInputArgsBuilder internal constructor() {
    private var isOfflineMigration: Output<Boolean>? = null

    private var sourceConnectionInfo: Output<MySqlConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<MySqlConnectionInfoArgs>? = null

    /**
     * @param value Flag for whether or not the migration is offline
     */
    @JvmName("pnsmwegtcjfdyrbu")
    public suspend fun isOfflineMigration(`value`: Output<Boolean>) {
        this.isOfflineMigration = value
    }

    /**
     * @param value Connection information for source MySQL server
     */
    @JvmName("dvtgqgdnpfqryutm")
    public suspend fun sourceConnectionInfo(`value`: Output<MySqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Connection information for target Azure Database for MySQL server
     */
    @JvmName("sjussoofliyylnmr")
    public suspend fun targetConnectionInfo(`value`: Output<MySqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Flag for whether or not the migration is offline
     */
    @JvmName("nhublahimbraxboq")
    public suspend fun isOfflineMigration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOfflineMigration = mapped
    }

    /**
     * @param value Connection information for source MySQL server
     */
    @JvmName("agvdbebisxlqisnt")
    public suspend fun sourceConnectionInfo(`value`: MySqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for source MySQL server
     */
    @JvmName("pvtnjeixddxlgjys")
    public suspend
    fun sourceConnectionInfo(argument: suspend MySqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MySqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Connection information for target Azure Database for MySQL server
     */
    @JvmName("qlqbtvwogicqguin")
    public suspend fun targetConnectionInfo(`value`: MySqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for target Azure Database for MySQL server
     */
    @JvmName("wknpymcskqupettf")
    public suspend
    fun targetConnectionInfo(argument: suspend MySqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MySqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): ConnectToTargetAzureDbForMySqlTaskInputArgs =
        ConnectToTargetAzureDbForMySqlTaskInputArgs(
            isOfflineMigration = isOfflineMigration,
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
