@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for the task that validates connection to Azure Database for PostgreSQL and target server requirements for Oracle source.
 * @property targetConnectionInfo Connection information for target Azure Database for PostgreSQL server
 */
public data class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs(
    public val targetConnectionInfo: Output<PostgreSqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs.builder()
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs].
 */
@PulumiTagMarker
public class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgsBuilder internal
constructor() {
    private var targetConnectionInfo: Output<PostgreSqlConnectionInfoArgs>? = null

    /**
     * @param value Connection information for target Azure Database for PostgreSQL server
     */
    @JvmName("ssnrnhwfsehueudd")
    public suspend fun targetConnectionInfo(`value`: Output<PostgreSqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Connection information for target Azure Database for PostgreSQL server
     */
    @JvmName("buwnwkqgrpjwfvbt")
    public suspend fun targetConnectionInfo(`value`: PostgreSqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for target Azure Database for PostgreSQL server
     */
    @JvmName("xcfafstfjpmalbnn")
    public suspend
    fun targetConnectionInfo(argument: suspend PostgreSqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PostgreSqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs =
        ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs(
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
