@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property migrationName Name of the migration.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property targetResourceName The name of the target resource/account.
 */
public data class GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs(
    public val migrationName: String,
    public val resourceGroupName: String,
    public val targetResourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs =
        com.pulumi.azurenative.datamigration.inputs.GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs.builder()
            .migrationName(migrationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .targetResourceName(targetResourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs].
 */
@PulumiTagMarker
public class GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgsBuilder internal constructor() {
    private var migrationName: String? = null

    private var resourceGroupName: String? = null

    private var targetResourceName: String? = null

    /**
     * @param value Name of the migration.
     */
    @JvmName("qjafmfwemnqqqqir")
    public suspend fun migrationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.migrationName = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("cepndlawovkhwmdy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the target resource/account.
     */
    @JvmName("cxwojspoggxxmcxf")
    public suspend fun targetResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetResourceName = mapped
    }

    internal fun build(): GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs =
        GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs(
            migrationName = migrationName ?: throw PulumiNullFieldException("migrationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            targetResourceName = targetResourceName ?: throw PulumiNullFieldException("targetResourceName"),
        )
}
