@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetDatabaseMigrationsSqlDbPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Complete migration details be included in the response.
 * @property migrationOperationId Optional migration operation ID. If this is provided, then details of migration operation for that ID are retrieved. If not provided (default), then details related to most recent or current operation are retrieved.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlDbInstanceName
 * @property targetDbName The name of the target database.
 */
public data class GetDatabaseMigrationsSqlDbPlainArgs(
    public val expand: String? = null,
    public val migrationOperationId: String? = null,
    public val resourceGroupName: String,
    public val sqlDbInstanceName: String,
    public val targetDbName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetDatabaseMigrationsSqlDbPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.GetDatabaseMigrationsSqlDbPlainArgs =
        com.pulumi.azurenative.datamigration.inputs.GetDatabaseMigrationsSqlDbPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .migrationOperationId(migrationOperationId?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlDbInstanceName(sqlDbInstanceName.let({ args0 -> args0 }))
            .targetDbName(targetDbName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatabaseMigrationsSqlDbPlainArgs].
 */
@PulumiTagMarker
public class GetDatabaseMigrationsSqlDbPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var migrationOperationId: String? = null

    private var resourceGroupName: String? = null

    private var sqlDbInstanceName: String? = null

    private var targetDbName: String? = null

    /**
     * @param value Complete migration details be included in the response.
     */
    @JvmName("ulpfxemajahkqyhg")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value Optional migration operation ID. If this is provided, then details of migration operation for that ID are retrieved. If not provided (default), then details related to most recent or current operation are retrieved.
     */
    @JvmName("icdedcavuxiemhiv")
    public suspend fun migrationOperationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.migrationOperationId = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("flgtojbaedkcwxne")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("dhlwevfjndkjgefk")
    public suspend fun sqlDbInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlDbInstanceName = mapped
    }

    /**
     * @param value The name of the target database.
     */
    @JvmName("ujshdwvqyoskvxcm")
    public suspend fun targetDbName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetDbName = mapped
    }

    internal fun build(): GetDatabaseMigrationsSqlDbPlainArgs = GetDatabaseMigrationsSqlDbPlainArgs(
        expand = expand,
        migrationOperationId = migrationOperationId,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sqlDbInstanceName = sqlDbInstanceName ?: throw PulumiNullFieldException("sqlDbInstanceName"),
        targetDbName = targetDbName ?: throw PulumiNullFieldException("targetDbName"),
    )
}
