@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetTdeCertificatesSqlTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for the task that gets TDE certificates in Base64 encoded format.
 * @property backupFileShare Backup file share information for file share to be used for temporarily storing files.
 * @property connectionInfo Connection information for SQL Server
 * @property selectedCertificates List containing certificate names and corresponding password to use for encrypting the exported certificate.
 */
public data class GetTdeCertificatesSqlTaskInputArgs(
    public val backupFileShare: Output<FileShareArgs>,
    public val connectionInfo: Output<SqlConnectionInfoArgs>,
    public val selectedCertificates: Output<List<SelectedCertificateInputArgs>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetTdeCertificatesSqlTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.GetTdeCertificatesSqlTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.GetTdeCertificatesSqlTaskInputArgs.builder()
            .backupFileShare(backupFileShare.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionInfo(connectionInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .selectedCertificates(
                selectedCertificates.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetTdeCertificatesSqlTaskInputArgs].
 */
@PulumiTagMarker
public class GetTdeCertificatesSqlTaskInputArgsBuilder internal constructor() {
    private var backupFileShare: Output<FileShareArgs>? = null

    private var connectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var selectedCertificates: Output<List<SelectedCertificateInputArgs>>? = null

    /**
     * @param value Backup file share information for file share to be used for temporarily storing files.
     */
    @JvmName("goaflanitlxeauyg")
    public suspend fun backupFileShare(`value`: Output<FileShareArgs>) {
        this.backupFileShare = value
    }

    /**
     * @param value Connection information for SQL Server
     */
    @JvmName("oyheeapvqbmsmrxl")
    public suspend fun connectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.connectionInfo = value
    }

    /**
     * @param value List containing certificate names and corresponding password to use for encrypting the exported certificate.
     */
    @JvmName("yvfdthquxhnubsej")
    public suspend fun selectedCertificates(`value`: Output<List<SelectedCertificateInputArgs>>) {
        this.selectedCertificates = value
    }

    @JvmName("wosjbpjockyhdemt")
    public suspend fun selectedCertificates(vararg values: Output<SelectedCertificateInputArgs>) {
        this.selectedCertificates = Output.all(values.asList())
    }

    /**
     * @param values List containing certificate names and corresponding password to use for encrypting the exported certificate.
     */
    @JvmName("qoyndoxbkpsyyodh")
    public suspend fun selectedCertificates(values: List<Output<SelectedCertificateInputArgs>>) {
        this.selectedCertificates = Output.all(values)
    }

    /**
     * @param value Backup file share information for file share to be used for temporarily storing files.
     */
    @JvmName("mtieipsumtlqebaq")
    public suspend fun backupFileShare(`value`: FileShareArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupFileShare = mapped
    }

    /**
     * @param argument Backup file share information for file share to be used for temporarily storing files.
     */
    @JvmName("jljvfyicduvuvqkd")
    public suspend fun backupFileShare(argument: suspend FileShareArgsBuilder.() -> Unit) {
        val toBeMapped = FileShareArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupFileShare = mapped
    }

    /**
     * @param value Connection information for SQL Server
     */
    @JvmName("lwnvtlavdnyaidrm")
    public suspend fun connectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionInfo = mapped
    }

    /**
     * @param argument Connection information for SQL Server
     */
    @JvmName("rwpjlnpfpfbfgfps")
    public suspend fun connectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionInfo = mapped
    }

    /**
     * @param value List containing certificate names and corresponding password to use for encrypting the exported certificate.
     */
    @JvmName("fjofmwrrgutljpwq")
    public suspend fun selectedCertificates(`value`: List<SelectedCertificateInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedCertificates = mapped
    }

    /**
     * @param argument List containing certificate names and corresponding password to use for encrypting the exported certificate.
     */
    @JvmName("uywklxiyarqbokmw")
    public suspend
    fun selectedCertificates(argument: List<suspend SelectedCertificateInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SelectedCertificateInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedCertificates = mapped
    }

    /**
     * @param argument List containing certificate names and corresponding password to use for encrypting the exported certificate.
     */
    @JvmName("bhlkraqpalxfjprm")
    public suspend fun selectedCertificates(
        vararg
        argument: suspend SelectedCertificateInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SelectedCertificateInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedCertificates = mapped
    }

    /**
     * @param argument List containing certificate names and corresponding password to use for encrypting the exported certificate.
     */
    @JvmName("jsqoesbvdvkukhpr")
    public suspend
    fun selectedCertificates(argument: suspend SelectedCertificateInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SelectedCertificateInputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.selectedCertificates = mapped
    }

    /**
     * @param values List containing certificate names and corresponding password to use for encrypting the exported certificate.
     */
    @JvmName("xvirghismvobwcjm")
    public suspend fun selectedCertificates(vararg values: SelectedCertificateInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedCertificates = mapped
    }

    internal fun build(): GetTdeCertificatesSqlTaskInputArgs = GetTdeCertificatesSqlTaskInputArgs(
        backupFileShare = backupFileShare ?: throw PulumiNullFieldException("backupFileShare"),
        connectionInfo = connectionInfo ?: throw PulumiNullFieldException("connectionInfo"),
        selectedCertificates = selectedCertificates ?: throw
            PulumiNullFieldException("selectedCertificates"),
    )
}
