@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetTdeCertificatesSqlTaskPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for the task that gets TDE certificates in Base64 encoded format.
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property input Task input
 * @property taskType Task type.
 * Expected value is 'GetTDECertificates.Sql'.
 */
public data class GetTdeCertificatesSqlTaskPropertiesArgs(
    public val clientData: Output<Map<String, String>>? = null,
    public val input: Output<GetTdeCertificatesSqlTaskInputArgs>? = null,
    public val taskType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetTdeCertificatesSqlTaskPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.GetTdeCertificatesSqlTaskPropertiesArgs =
        com.pulumi.azurenative.datamigration.inputs.GetTdeCertificatesSqlTaskPropertiesArgs.builder()
            .clientData(
                clientData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskType(taskType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTdeCertificatesSqlTaskPropertiesArgs].
 */
@PulumiTagMarker
public class GetTdeCertificatesSqlTaskPropertiesArgsBuilder internal constructor() {
    private var clientData: Output<Map<String, String>>? = null

    private var input: Output<GetTdeCertificatesSqlTaskInputArgs>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("vkamoapnryxieynu")
    public suspend fun clientData(`value`: Output<Map<String, String>>) {
        this.clientData = value
    }

    /**
     * @param value Task input
     */
    @JvmName("tupkyheulmskwxyu")
    public suspend fun input(`value`: Output<GetTdeCertificatesSqlTaskInputArgs>) {
        this.input = value
    }

    /**
     * @param value Task type.
     * Expected value is 'GetTDECertificates.Sql'.
     */
    @JvmName("esuhaetvygsaabgl")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("lsveulmuevigvgnd")
    public suspend fun clientData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param values Key value pairs of client data to attach meta data information to task
     */
    @JvmName("anwmqllckpvmvdkw")
    public fun clientData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param value Task input
     */
    @JvmName("qqcohggshvsolnoo")
    public suspend fun input(`value`: GetTdeCertificatesSqlTaskInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Task input
     */
    @JvmName("nikutugwueomojfm")
    public suspend fun input(argument: suspend GetTdeCertificatesSqlTaskInputArgsBuilder.() -> Unit) {
        val toBeMapped = GetTdeCertificatesSqlTaskInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Task type.
     * Expected value is 'GetTDECertificates.Sql'.
     */
    @JvmName("xdhkoyhxrvwppume")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): GetTdeCertificatesSqlTaskPropertiesArgs =
        GetTdeCertificatesSqlTaskPropertiesArgs(
            clientData = clientData,
            input = input,
            taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        )
}
