@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetUserTablesOracleTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for the task that gets the list of tables contained within a provided list of Oracle schemas.
 * @property connectionInfo Information for connecting to Oracle source
 * @property selectedSchemas List of Oracle schemas for which to collect tables
 */
public data class GetUserTablesOracleTaskInputArgs(
    public val connectionInfo: Output<OracleConnectionInfoArgs>,
    public val selectedSchemas: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetUserTablesOracleTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.GetUserTablesOracleTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.GetUserTablesOracleTaskInputArgs.builder()
            .connectionInfo(connectionInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .selectedSchemas(selectedSchemas.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetUserTablesOracleTaskInputArgs].
 */
@PulumiTagMarker
public class GetUserTablesOracleTaskInputArgsBuilder internal constructor() {
    private var connectionInfo: Output<OracleConnectionInfoArgs>? = null

    private var selectedSchemas: Output<List<String>>? = null

    /**
     * @param value Information for connecting to Oracle source
     */
    @JvmName("fxlbmycqwenskbcc")
    public suspend fun connectionInfo(`value`: Output<OracleConnectionInfoArgs>) {
        this.connectionInfo = value
    }

    /**
     * @param value List of Oracle schemas for which to collect tables
     */
    @JvmName("bjnmjxxpdkyfleip")
    public suspend fun selectedSchemas(`value`: Output<List<String>>) {
        this.selectedSchemas = value
    }

    @JvmName("kjhlbjimsnrcydua")
    public suspend fun selectedSchemas(vararg values: Output<String>) {
        this.selectedSchemas = Output.all(values.asList())
    }

    /**
     * @param values List of Oracle schemas for which to collect tables
     */
    @JvmName("gyrmciacprbmhkmj")
    public suspend fun selectedSchemas(values: List<Output<String>>) {
        this.selectedSchemas = Output.all(values)
    }

    /**
     * @param value Information for connecting to Oracle source
     */
    @JvmName("fdgwvtfwibythada")
    public suspend fun connectionInfo(`value`: OracleConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to Oracle source
     */
    @JvmName("ytvyfcorluxesmbq")
    public suspend fun connectionInfo(argument: suspend OracleConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = OracleConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionInfo = mapped
    }

    /**
     * @param value List of Oracle schemas for which to collect tables
     */
    @JvmName("lgiqonpaymwrwwer")
    public suspend fun selectedSchemas(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedSchemas = mapped
    }

    /**
     * @param values List of Oracle schemas for which to collect tables
     */
    @JvmName("ovlpyxkpbpyrsqgk")
    public suspend fun selectedSchemas(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedSchemas = mapped
    }

    internal fun build(): GetUserTablesOracleTaskInputArgs = GetUserTablesOracleTaskInputArgs(
        connectionInfo = connectionInfo ?: throw PulumiNullFieldException("connectionInfo"),
        selectedSchemas = selectedSchemas ?: throw PulumiNullFieldException("selectedSchemas"),
    )
}
