@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ListSqlMigrationServiceMonitoringDataPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlMigrationServiceName Name of the SQL Migration Service.
 */
public data class ListSqlMigrationServiceMonitoringDataPlainArgs(
    public val resourceGroupName: String,
    public val sqlMigrationServiceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ListSqlMigrationServiceMonitoringDataPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ListSqlMigrationServiceMonitoringDataPlainArgs =
        com.pulumi.azurenative.datamigration.inputs.ListSqlMigrationServiceMonitoringDataPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlMigrationServiceName(sqlMigrationServiceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListSqlMigrationServiceMonitoringDataPlainArgs].
 */
@PulumiTagMarker
public class ListSqlMigrationServiceMonitoringDataPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sqlMigrationServiceName: String? = null

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ijljqxusykuiuukw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SQL Migration Service.
     */
    @JvmName("vuoodlahpakyvspq")
    public suspend fun sqlMigrationServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlMigrationServiceName = mapped
    }

    internal fun build(): ListSqlMigrationServiceMonitoringDataPlainArgs =
        ListSqlMigrationServiceMonitoringDataPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sqlMigrationServiceName = sqlMigrationServiceName ?: throw
                PulumiNullFieldException("sqlMigrationServiceName"),
        )
}
