@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Database specific information for MySQL to Azure Database for MySQL migration task inputs
 * @property migrationSetting Migration settings which tune the migration behavior
 * @property name Name of the database
 * @property sourceSetting Source settings to tune source endpoint migration behavior
 * @property tableMap Mapping of source to target tables
 * @property targetDatabaseName Name of target database. Note: Target database will be truncated before starting migration.
 * @property targetSetting Target settings to tune target endpoint migration behavior
 */
public data class MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs(
    public val migrationSetting: Output<Map<String, String>>? = null,
    public val name: Output<String>? = null,
    public val sourceSetting: Output<Map<String, String>>? = null,
    public val tableMap: Output<Map<String, String>>? = null,
    public val targetDatabaseName: Output<String>? = null,
    public val targetSetting: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs.builder()
            .migrationSetting(
                migrationSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .sourceSetting(
                sourceSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tableMap(
                tableMap?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetDatabaseName(targetDatabaseName?.applyValue({ args0 -> args0 }))
            .targetSetting(
                targetSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs].
 */
@PulumiTagMarker
public class MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgsBuilder internal constructor() {
    private var migrationSetting: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var sourceSetting: Output<Map<String, String>>? = null

    private var tableMap: Output<Map<String, String>>? = null

    private var targetDatabaseName: Output<String>? = null

    private var targetSetting: Output<Map<String, String>>? = null

    /**
     * @param value Migration settings which tune the migration behavior
     */
    @JvmName("ifyhshxaqldrablp")
    public suspend fun migrationSetting(`value`: Output<Map<String, String>>) {
        this.migrationSetting = value
    }

    /**
     * @param value Name of the database
     */
    @JvmName("taptyoctvnnowqus")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Source settings to tune source endpoint migration behavior
     */
    @JvmName("hwkcqbmsvmkueawv")
    public suspend fun sourceSetting(`value`: Output<Map<String, String>>) {
        this.sourceSetting = value
    }

    /**
     * @param value Mapping of source to target tables
     */
    @JvmName("rofmlsfsyhafgswf")
    public suspend fun tableMap(`value`: Output<Map<String, String>>) {
        this.tableMap = value
    }

    /**
     * @param value Name of target database. Note: Target database will be truncated before starting migration.
     */
    @JvmName("mrbfeusggggkwpfp")
    public suspend fun targetDatabaseName(`value`: Output<String>) {
        this.targetDatabaseName = value
    }

    /**
     * @param value Target settings to tune target endpoint migration behavior
     */
    @JvmName("hspjqvefhsffwhxw")
    public suspend fun targetSetting(`value`: Output<Map<String, String>>) {
        this.targetSetting = value
    }

    /**
     * @param value Migration settings which tune the migration behavior
     */
    @JvmName("ussfhfpqhfsoabkh")
    public suspend fun migrationSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationSetting = mapped
    }

    /**
     * @param values Migration settings which tune the migration behavior
     */
    @JvmName("qfsmiidywdoxqpha")
    public fun migrationSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationSetting = mapped
    }

    /**
     * @param value Name of the database
     */
    @JvmName("vthdcumolufqecub")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Source settings to tune source endpoint migration behavior
     */
    @JvmName("wcgpypwjtyxikoje")
    public suspend fun sourceSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSetting = mapped
    }

    /**
     * @param values Source settings to tune source endpoint migration behavior
     */
    @JvmName("rfcbpystkikchjoi")
    public fun sourceSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceSetting = mapped
    }

    /**
     * @param value Mapping of source to target tables
     */
    @JvmName("kuaojkuaffueasse")
    public suspend fun tableMap(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableMap = mapped
    }

    /**
     * @param values Mapping of source to target tables
     */
    @JvmName("esxwcgmdoppohmho")
    public fun tableMap(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableMap = mapped
    }

    /**
     * @param value Name of target database. Note: Target database will be truncated before starting migration.
     */
    @JvmName("knyvxrqhsyotulnl")
    public suspend fun targetDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDatabaseName = mapped
    }

    /**
     * @param value Target settings to tune target endpoint migration behavior
     */
    @JvmName("ctefnblyhgjaoncv")
    public suspend fun targetSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSetting = mapped
    }

    /**
     * @param values Target settings to tune target endpoint migration behavior
     */
    @JvmName("txvdeerjxxdnkhao")
    public fun targetSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetSetting = mapped
    }

    internal fun build(): MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs =
        MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs(
            migrationSetting = migrationSetting,
            name = name,
            sourceSetting = sourceSetting,
            tableMap = tableMap,
            targetDatabaseName = targetDatabaseName,
            targetSetting = targetSetting,
        )
}
