@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for the task that migrates Oracle to Azure Database for PostgreSQL for online migrations
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property input Task input
 * @property taskType Task type.
 * Expected value is 'Migrate.Oracle.AzureDbForPostgreSql.Sync'.
 */
public data class MigrateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs(
    public val clientData: Output<Map<String, String>>? = null,
    public val input: Output<MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs>? = null,
    public val taskType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs.builder()
            .clientData(
                clientData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskType(taskType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs].
 */
@PulumiTagMarker
public class MigrateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgsBuilder internal constructor() {
    private var clientData: Output<Map<String, String>>? = null

    private var input: Output<MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("iksgxnxovkafbysm")
    public suspend fun clientData(`value`: Output<Map<String, String>>) {
        this.clientData = value
    }

    /**
     * @param value Task input
     */
    @JvmName("kmuvcuiitssixols")
    public suspend fun input(`value`: Output<MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs>) {
        this.input = value
    }

    /**
     * @param value Task type.
     * Expected value is 'Migrate.Oracle.AzureDbForPostgreSql.Sync'.
     */
    @JvmName("ywmqarolwsqpsueb")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("mykpintndoakjibp")
    public suspend fun clientData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param values Key value pairs of client data to attach meta data information to task
     */
    @JvmName("giensyrmslsxkxga")
    public fun clientData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param value Task input
     */
    @JvmName("bkegymcmtuwamosr")
    public suspend fun input(`value`: MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Task input
     */
    @JvmName("wchkhfceyroynnks")
    public suspend
    fun input(argument: suspend MigrateOracleAzureDbPostgreSqlSyncTaskInputArgsBuilder.() -> Unit) {
        val toBeMapped = MigrateOracleAzureDbPostgreSqlSyncTaskInputArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Task type.
     * Expected value is 'Migrate.Oracle.AzureDbForPostgreSql.Sync'.
     */
    @JvmName("mueiynbvskxwnykl")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): MigrateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs =
        MigrateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs(
            clientData = clientData,
            input = input,
            taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        )
}
