@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Information for connecting to source
 * @property targetConnectionInfo Information for connecting to target
 * @property validationOptions Validation options
 */
public data class MigrateSqlServerSqlDbSyncTaskInputArgs(
    public val selectedDatabases: Output<List<MigrateSqlServerSqlDbSyncDatabaseInputArgs>>,
    public val sourceConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val targetConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val validationOptions: Output<MigrationValidationOptionsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncTaskInputArgs.builder()
            .selectedDatabases(
                selectedDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .validationOptions(
                validationOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MigrateSqlServerSqlDbSyncTaskInputArgs].
 */
@PulumiTagMarker
public class MigrateSqlServerSqlDbSyncTaskInputArgsBuilder internal constructor() {
    private var selectedDatabases: Output<List<MigrateSqlServerSqlDbSyncDatabaseInputArgs>>? = null

    private var sourceConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var validationOptions: Output<MigrationValidationOptionsArgs>? = null

    /**
     * @param value Databases to migrate
     */
    @JvmName("cgrvyamdqcdegefl")
    public suspend
    fun selectedDatabases(`value`: Output<List<MigrateSqlServerSqlDbSyncDatabaseInputArgs>>) {
        this.selectedDatabases = value
    }

    @JvmName("gjlbmnvdhnyugqjm")
    public suspend fun selectedDatabases(
        vararg
        values: Output<MigrateSqlServerSqlDbSyncDatabaseInputArgs>,
    ) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("ejcogfnkhwcoynji")
    public suspend
    fun selectedDatabases(values: List<Output<MigrateSqlServerSqlDbSyncDatabaseInputArgs>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Information for connecting to source
     */
    @JvmName("wbshxxafedcpeaif")
    public suspend fun sourceConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("hvmkxqbhtadlhmaa")
    public suspend fun targetConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Validation options
     */
    @JvmName("smucqujkiwwmqwjt")
    public suspend fun validationOptions(`value`: Output<MigrationValidationOptionsArgs>) {
        this.validationOptions = value
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("udpqlbtdrmemhbdv")
    public suspend fun selectedDatabases(`value`: List<MigrateSqlServerSqlDbSyncDatabaseInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("qpvmblhxqttiqcwi")
    public suspend
    fun selectedDatabases(argument: List<suspend MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("wdrsdypssxqjaiax")
    public suspend fun selectedDatabases(
        vararg
        argument: suspend MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("hhtnhcopgdwjkymd")
    public suspend
    fun selectedDatabases(argument: suspend MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("efcvukbsslbxsgye")
    public suspend fun selectedDatabases(vararg values: MigrateSqlServerSqlDbSyncDatabaseInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param value Information for connecting to source
     */
    @JvmName("bdudtrvthcfrmejg")
    public suspend fun sourceConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to source
     */
    @JvmName("rftyytorbyndlnxw")
    public suspend
    fun sourceConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("ptxqrcdipfifshvf")
    public suspend fun targetConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to target
     */
    @JvmName("xbuxkgsdpgfafhew")
    public suspend
    fun targetConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    /**
     * @param value Validation options
     */
    @JvmName("tfmhyvqchkiodmjk")
    public suspend fun validationOptions(`value`: MigrationValidationOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationOptions = mapped
    }

    /**
     * @param argument Validation options
     */
    @JvmName("ejxfdsusbjebdyrg")
    public suspend
    fun validationOptions(argument: suspend MigrationValidationOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = MigrationValidationOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationOptions = mapped
    }

    internal fun build(): MigrateSqlServerSqlDbSyncTaskInputArgs =
        MigrateSqlServerSqlDbSyncTaskInputArgs(
            selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
            validationOptions = validationOptions,
        )
}
