@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateSsisTaskPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for task that migrates SSIS packages from SQL Server databases to Azure SQL Database Managed Instance.
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property input Task input
 * @property taskType Task type.
 * Expected value is 'Migrate.Ssis'.
 */
public data class MigrateSsisTaskPropertiesArgs(
    public val clientData: Output<Map<String, String>>? = null,
    public val input: Output<MigrateSsisTaskInputArgs>? = null,
    public val taskType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateSsisTaskPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MigrateSsisTaskPropertiesArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateSsisTaskPropertiesArgs.builder()
            .clientData(
                clientData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskType(taskType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrateSsisTaskPropertiesArgs].
 */
@PulumiTagMarker
public class MigrateSsisTaskPropertiesArgsBuilder internal constructor() {
    private var clientData: Output<Map<String, String>>? = null

    private var input: Output<MigrateSsisTaskInputArgs>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("fekefgshhmedcuwk")
    public suspend fun clientData(`value`: Output<Map<String, String>>) {
        this.clientData = value
    }

    /**
     * @param value Task input
     */
    @JvmName("cheebcwdmyydmoox")
    public suspend fun input(`value`: Output<MigrateSsisTaskInputArgs>) {
        this.input = value
    }

    /**
     * @param value Task type.
     * Expected value is 'Migrate.Ssis'.
     */
    @JvmName("ibstdwnnrcehbpxb")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("bpjvvvwpdkscflkj")
    public suspend fun clientData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param values Key value pairs of client data to attach meta data information to task
     */
    @JvmName("ftaphuycwjluyuwt")
    public fun clientData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param value Task input
     */
    @JvmName("salcsrdlmhmnhwuo")
    public suspend fun input(`value`: MigrateSsisTaskInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Task input
     */
    @JvmName("pksameddmxmaolix")
    public suspend fun input(argument: suspend MigrateSsisTaskInputArgsBuilder.() -> Unit) {
        val toBeMapped = MigrateSsisTaskInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Task type.
     * Expected value is 'Migrate.Ssis'.
     */
    @JvmName("fnbcnboeloovqica")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): MigrateSsisTaskPropertiesArgs = MigrateSsisTaskPropertiesArgs(
        clientData = clientData,
        input = input,
        taskType = taskType ?: throw PulumiNullFieldException("taskType"),
    )
}
