@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MySqlConnectionInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information for connecting to MySQL server
 * @property encryptConnection Whether to encrypt the connection
 * @property password Password credential.
 * @property port Port for Server
 * @property serverName Name of the server
 * @property type Type of connection info
 * Expected value is 'MySqlConnectionInfo'.
 * @property userName User name
 */
public data class MySqlConnectionInfoArgs(
    public val encryptConnection: Output<Boolean>? = null,
    public val password: Output<String>? = null,
    public val port: Output<Int>,
    public val serverName: Output<String>,
    public val type: Output<String>,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MySqlConnectionInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MySqlConnectionInfoArgs =
        com.pulumi.azurenative.datamigration.inputs.MySqlConnectionInfoArgs.builder()
            .encryptConnection(encryptConnection?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .serverName(serverName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MySqlConnectionInfoArgs].
 */
@PulumiTagMarker
public class MySqlConnectionInfoArgsBuilder internal constructor() {
    private var encryptConnection: Output<Boolean>? = null

    private var password: Output<String>? = null

    private var port: Output<Int>? = null

    private var serverName: Output<String>? = null

    private var type: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Whether to encrypt the connection
     */
    @JvmName("ehqprcaldiismvdv")
    public suspend fun encryptConnection(`value`: Output<Boolean>) {
        this.encryptConnection = value
    }

    /**
     * @param value Password credential.
     */
    @JvmName("gudjbmvityinvwtg")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Port for Server
     */
    @JvmName("sakqisheqaxthtnl")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Name of the server
     */
    @JvmName("dmqtmtaeiikfoshx")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Type of connection info
     * Expected value is 'MySqlConnectionInfo'.
     */
    @JvmName("efsplyldvtcghvgf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value User name
     */
    @JvmName("soagafrihirqpmjf")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Whether to encrypt the connection
     */
    @JvmName("qyfdayfnoastwtef")
    public suspend fun encryptConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptConnection = mapped
    }

    /**
     * @param value Password credential.
     */
    @JvmName("yhnwsskniqkuoqem")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Port for Server
     */
    @JvmName("xfjsyleseebvluse")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Name of the server
     */
    @JvmName("fbechgvfjwhtbyap")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Type of connection info
     * Expected value is 'MySqlConnectionInfo'.
     */
    @JvmName("vgrybbyxnpycahty")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value User name
     */
    @JvmName("fknekodqigfadbld")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): MySqlConnectionInfoArgs = MySqlConnectionInfoArgs(
        encryptConnection = encryptConnection,
        password = password,
        port = port ?: throw PulumiNullFieldException("port"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName,
    )
}
