@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.SqlConnectionInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Source SQL Connection
 * @property authentication Authentication type.
 * @property dataSource Data source.
 * @property encryptConnection Whether to encrypt connection or not.
 * @property password Password to connect to source SQL.
 * @property trustServerCertificate Whether to trust server certificate or not.
 * @property userName User name to connect to source SQL.
 */
public data class SqlConnectionInformationArgs(
    public val authentication: Output<String>? = null,
    public val dataSource: Output<String>? = null,
    public val encryptConnection: Output<Boolean>? = null,
    public val password: Output<String>? = null,
    public val trustServerCertificate: Output<Boolean>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.SqlConnectionInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.SqlConnectionInformationArgs =
        com.pulumi.azurenative.datamigration.inputs.SqlConnectionInformationArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .dataSource(dataSource?.applyValue({ args0 -> args0 }))
            .encryptConnection(encryptConnection?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .trustServerCertificate(trustServerCertificate?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlConnectionInformationArgs].
 */
@PulumiTagMarker
public class SqlConnectionInformationArgsBuilder internal constructor() {
    private var authentication: Output<String>? = null

    private var dataSource: Output<String>? = null

    private var encryptConnection: Output<Boolean>? = null

    private var password: Output<String>? = null

    private var trustServerCertificate: Output<Boolean>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Authentication type.
     */
    @JvmName("bogknirckvrwswus")
    public suspend fun authentication(`value`: Output<String>) {
        this.authentication = value
    }

    /**
     * @param value Data source.
     */
    @JvmName("pyfbqepiboktudue")
    public suspend fun dataSource(`value`: Output<String>) {
        this.dataSource = value
    }

    /**
     * @param value Whether to encrypt connection or not.
     */
    @JvmName("koxbskcmbeuarkac")
    public suspend fun encryptConnection(`value`: Output<Boolean>) {
        this.encryptConnection = value
    }

    /**
     * @param value Password to connect to source SQL.
     */
    @JvmName("bygbexwtqxbcvefb")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Whether to trust server certificate or not.
     */
    @JvmName("cilvduiqelpslyca")
    public suspend fun trustServerCertificate(`value`: Output<Boolean>) {
        this.trustServerCertificate = value
    }

    /**
     * @param value User name to connect to source SQL.
     */
    @JvmName("wkbgppdllxvvtrrl")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Authentication type.
     */
    @JvmName("pdwhrggrstfalgjq")
    public suspend fun authentication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value Data source.
     */
    @JvmName("uafcptyxglgdsdln")
    public suspend fun dataSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value Whether to encrypt connection or not.
     */
    @JvmName("sbemqqgpokatyiac")
    public suspend fun encryptConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptConnection = mapped
    }

    /**
     * @param value Password to connect to source SQL.
     */
    @JvmName("osnaqjmnihgjvbbd")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Whether to trust server certificate or not.
     */
    @JvmName("aqqgiqlnftabilop")
    public suspend fun trustServerCertificate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustServerCertificate = mapped
    }

    /**
     * @param value User name to connect to source SQL.
     */
    @JvmName("ckmwhfbgtxnnssuy")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): SqlConnectionInformationArgs = SqlConnectionInformationArgs(
        authentication = authentication,
        dataSource = dataSource,
        encryptConnection = encryptConnection,
        password = password,
        trustServerCertificate = trustServerCertificate,
        userName = userName,
    )
}
