@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for connect to MySQL type source
 * @property databases List of databases on the server
 * @property id Result identifier
 * @property serverProperties Server properties
 * @property sourceServerBrandVersion Server brand version
 * @property validationErrors Validation errors associated with the task
 */
public data class ConnectToSourceNonSqlTaskOutputResponse(
    public val databases: List<String>,
    public val id: String,
    public val serverProperties: ServerPropertiesResponse,
    public val sourceServerBrandVersion: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToSourceNonSqlTaskOutputResponse):
            ConnectToSourceNonSqlTaskOutputResponse = ConnectToSourceNonSqlTaskOutputResponse(
            databases = javaType.databases().map({ args0 -> args0 }),
            id = javaType.id(),
            serverProperties = javaType.serverProperties().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.ServerPropertiesResponse.Companion.toKotlin(args0)
            }),
            sourceServerBrandVersion = javaType.sourceServerBrandVersion(),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
