@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for the task that validates connection to PostgreSQL and source server requirements
 * @property databases List of databases on source server
 * @property id Result identifier
 * @property sourceServerBrandVersion Source server brand version
 * @property sourceServerVersion Version of the source server
 * @property validationErrors Validation errors associated with the task
 */
public data class ConnectToSourcePostgreSqlSyncTaskOutputResponse(
    public val databases: List<String>,
    public val id: String,
    public val sourceServerBrandVersion: String,
    public val sourceServerVersion: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToSourcePostgreSqlSyncTaskOutputResponse):
            ConnectToSourcePostgreSqlSyncTaskOutputResponse =
            ConnectToSourcePostgreSqlSyncTaskOutputResponse(
                databases = javaType.databases().map({ args0 -> args0 }),
                id = javaType.id(),
                sourceServerBrandVersion = javaType.sourceServerBrandVersion(),
                sourceServerVersion = javaType.sourceServerVersion(),
                validationErrors = javaType.validationErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
