@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for the task that validates connection to Azure Database for MySQL and target server requirements
 * @property databases List of databases on target server
 * @property id Result identifier
 * @property serverVersion Version of the target server
 * @property targetServerBrandVersion Target server brand version
 * @property validationErrors Validation errors associated with the task
 */
public data class ConnectToTargetAzureDbForMySqlTaskOutputResponse(
    public val databases: List<String>,
    public val id: String,
    public val serverVersion: String,
    public val targetServerBrandVersion: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetAzureDbForMySqlTaskOutputResponse):
            ConnectToTargetAzureDbForMySqlTaskOutputResponse =
            ConnectToTargetAzureDbForMySqlTaskOutputResponse(
                databases = javaType.databases().map({ args0 -> args0 }),
                id = javaType.id(),
                serverVersion = javaType.serverVersion(),
                targetServerBrandVersion = javaType.targetServerBrandVersion(),
                validationErrors = javaType.validationErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
