@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress

/**
 * Input for the task that validates connection to SQL DB and target server requirements
 * @property targetConnectionInfo Connection information for target SQL DB
 */
public data class ConnectToTargetSqlDbTaskInputResponse(
    public val targetConnectionInfo: SqlConnectionInfoResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetSqlDbTaskInputResponse):
            ConnectToTargetSqlDbTaskInputResponse = ConnectToTargetSqlDbTaskInputResponse(
            targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
