@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for the task that validates connection to Azure SQL Database Managed Instance.
 * @property agentJobs List of agent jobs on the target server.
 * @property id Result identifier
 * @property logins List of logins on the target server.
 * @property targetServerBrandVersion Target server brand version
 * @property targetServerVersion Target server version
 * @property validationErrors Validation errors
 */
public data class ConnectToTargetSqlMITaskOutputResponse(
    public val agentJobs: List<String>,
    public val id: String,
    public val logins: List<String>,
    public val targetServerBrandVersion: String,
    public val targetServerVersion: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetSqlMITaskOutputResponse):
            ConnectToTargetSqlMITaskOutputResponse = ConnectToTargetSqlMITaskOutputResponse(
            agentJobs = javaType.agentJobs().map({ args0 -> args0 }),
            id = javaType.id(),
            logins = javaType.logins().map({ args0 -> args0 }),
            targetServerBrandVersion = javaType.targetServerBrandVersion(),
            targetServerVersion = javaType.targetServerVersion(),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
