@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Output of the task that gets TDE certificates in Base64 encoded format.
 * @property base64EncodedCertificates Mapping from certificate name to base 64 encoded format.
 * @property validationErrors Validation errors
 */
public data class GetTdeCertificatesSqlTaskOutputResponse(
    public val base64EncodedCertificates: Map<String, List<String>>,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetTdeCertificatesSqlTaskOutputResponse):
            GetTdeCertificatesSqlTaskOutputResponse = GetTdeCertificatesSqlTaskOutputResponse(
            base64EncodedCertificates = javaType.base64EncodedCertificates().map({ args0 ->
                args0.key.to(args0.value.map({ args0 -> args0 }))
            }).toMap(),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
