@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for the task that gets the list of tables for a provided list of PostgreSQL databases.
 * @property databaseName The database this result is for
 * @property tables List of valid tables found for this database
 * @property validationErrors Validation errors associated with the task
 */
public data class GetUserTablesPostgreSqlTaskOutputResponse(
    public val databaseName: String,
    public val tables: List<DatabaseTableResponse>,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetUserTablesPostgreSqlTaskOutputResponse):
            GetUserTablesPostgreSqlTaskOutputResponse = GetUserTablesPostgreSqlTaskOutputResponse(
            databaseName = javaType.databaseName(),
            tables = javaType.tables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseTableResponse.Companion.toKotlin(args0)
                })
            }),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
