@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An authentication key.
 * @property authKey1 The first authentication key.
 * @property authKey2 The second authentication key.
 */
public data class ListSqlMigrationServiceAuthKeysResult(
    public val authKey1: String? = null,
    public val authKey2: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ListSqlMigrationServiceAuthKeysResult):
            ListSqlMigrationServiceAuthKeysResult = ListSqlMigrationServiceAuthKeysResult(
            authKey1 = javaType.authKey1().map({ args0 -> args0 }).orElse(null),
            authKey2 = javaType.authKey2().map({ args0 -> args0 }).orElse(null),
        )
    }
}
