@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Input for command that completes online migration for an Azure SQL Database Managed Instance.
 * @property sourceDatabaseName Name of managed instance database
 */
public data class MigrateMISyncCompleteCommandInputResponse(
    public val sourceDatabaseName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateMISyncCompleteCommandInputResponse):
            MigrateMISyncCompleteCommandInputResponse = MigrateMISyncCompleteCommandInputResponse(
            sourceDatabaseName = javaType.sourceDatabaseName(),
        )
    }
}
