@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endedOn Migration end time
 * @property errorPrefix Wildcard string prefix to use for querying all errors of the item
 * @property id Result identifier
 * @property itemsCompletedCount Number of successfully completed items
 * @property itemsCount Number of items
 * @property lastStorageUpdate Last time the storage was updated
 * @property objectName Name of the item
 * @property resultPrefix Wildcard string prefix to use for querying all sub-tem results of the item
 * @property resultType Result type
 * Expected value is 'TableLevelOutput'.
 * @property startedOn Migration start time
 * @property state Current state of migration
 * @property statusMessage Status message
 */
public data class MigrateMySqlAzureDbForMySqlOfflineTaskOutputTableLevelResponse(
    public val endedOn: String,
    public val errorPrefix: String,
    public val id: String,
    public val itemsCompletedCount: Double,
    public val itemsCount: Double,
    public val lastStorageUpdate: String,
    public val objectName: String,
    public val resultPrefix: String,
    public val resultType: String,
    public val startedOn: String,
    public val state: String,
    public val statusMessage: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateMySqlAzureDbForMySqlOfflineTaskOutputTableLevelResponse):
            MigrateMySqlAzureDbForMySqlOfflineTaskOutputTableLevelResponse =
            MigrateMySqlAzureDbForMySqlOfflineTaskOutputTableLevelResponse(
                endedOn = javaType.endedOn(),
                errorPrefix = javaType.errorPrefix(),
                id = javaType.id(),
                itemsCompletedCount = javaType.itemsCompletedCount(),
                itemsCount = javaType.itemsCount(),
                lastStorageUpdate = javaType.lastStorageUpdate(),
                objectName = javaType.objectName(),
                resultPrefix = javaType.resultPrefix(),
                resultType = javaType.resultType(),
                startedOn = javaType.startedOn(),
                state = javaType.state(),
                statusMessage = javaType.statusMessage(),
            )
    }
}
