@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property errorMessage Error message
 * @property events List of error events.
 * @property id Result identifier
 * @property resultType Result type
 * Expected value is 'DatabaseLevelErrorOutput'.
 */
public data class MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseErrorResponse(
    public val errorMessage: String? = null,
    public val events: List<SyncMigrationDatabaseErrorEventResponse>? = null,
    public val id: String,
    public val resultType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseErrorResponse):
            MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseErrorResponse =
            MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseErrorResponse(
                errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
                events = javaType.events().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.SyncMigrationDatabaseErrorEventResponse.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                resultType = javaType.resultType(),
            )
    }
}
