@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property databaseCount Count of databases
 * @property databaseErrorCount Number of database level errors
 * @property endedOn Migration end time
 * @property id Result identifier
 * @property resultType Result type
 * Expected value is 'MigrationLevelOutput'.
 * @property sourceServerBrandVersion Source server brand version
 * @property sourceServerName Source server name
 * @property sourceServerVersion Source server version
 * @property startedOn Migration start time
 * @property state Current state of migration
 * @property targetServerBrandVersion Target server brand version
 * @property targetServerName Target server name
 * @property targetServerVersion Target server version
 */
public data class MigrateSqlServerSqlMISyncTaskOutputMigrationLevelResponse(
    public val databaseCount: Int,
    public val databaseErrorCount: Int,
    public val endedOn: String,
    public val id: String,
    public val resultType: String,
    public val sourceServerBrandVersion: String,
    public val sourceServerName: String,
    public val sourceServerVersion: String,
    public val startedOn: String,
    public val state: String,
    public val targetServerBrandVersion: String,
    public val targetServerName: String,
    public val targetServerVersion: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlMISyncTaskOutputMigrationLevelResponse):
            MigrateSqlServerSqlMISyncTaskOutputMigrationLevelResponse =
            MigrateSqlServerSqlMISyncTaskOutputMigrationLevelResponse(
                databaseCount = javaType.databaseCount(),
                databaseErrorCount = javaType.databaseErrorCount(),
                endedOn = javaType.endedOn(),
                id = javaType.id(),
                resultType = javaType.resultType(),
                sourceServerBrandVersion = javaType.sourceServerBrandVersion(),
                sourceServerName = javaType.sourceServerName(),
                sourceServerVersion = javaType.sourceServerVersion(),
                startedOn = javaType.startedOn(),
                state = javaType.state(),
                targetServerBrandVersion = javaType.targetServerBrandVersion(),
                targetServerName = javaType.targetServerName(),
                targetServerVersion = javaType.targetServerVersion(),
            )
    }
}
