@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress

/**
 * Input for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed Instance.
 * @property sourceConnectionInfo Information for connecting to source
 * @property ssisMigrationInfo SSIS package migration information.
 * @property targetConnectionInfo Information for connecting to target
 */
public data class MigrateSsisTaskInputResponse(
    public val sourceConnectionInfo: SqlConnectionInfoResponse,
    public val ssisMigrationInfo: SsisMigrationInfoResponse,
    public val targetConnectionInfo: SqlConnectionInfoResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSsisTaskInputResponse):
            MigrateSsisTaskInputResponse = MigrateSsisTaskInputResponse(
            sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            ssisMigrationInfo = javaType.ssisMigrationInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SsisMigrationInfoResponse.Companion.toKotlin(args0)
            }),
            targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
