@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Input for command that completes sync migration for a database.
 * @property commitTimeStamp Time stamp to complete
 * @property databaseName Name of database
 */
public data class MigrateSyncCompleteCommandInputResponse(
    public val commitTimeStamp: String? = null,
    public val databaseName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSyncCompleteCommandInputResponse):
            MigrateSyncCompleteCommandInputResponse = MigrateSyncCompleteCommandInputResponse(
            commitTimeStamp = javaType.commitTimeStamp().map({ args0 -> args0 }).orElse(null),
            databaseName = javaType.databaseName(),
        )
    }
}
