@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Information about migration eligibility of a server object
 * @property isEligibleForMigration Whether object is eligible for migration or not.
 * @property validationMessages Information about eligibility failure for the server object.
 */
public data class MigrationEligibilityInfoResponse(
    public val isEligibleForMigration: Boolean,
    public val validationMessages: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrationEligibilityInfoResponse):
            MigrationEligibilityInfoResponse = MigrationEligibilityInfoResponse(
            isEligibleForMigration = javaType.isEligibleForMigration(),
            validationMessages = javaType.validationMessages().map({ args0 -> args0 }),
        )
    }
}
