@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Migration validation report result, contains the url for downloading the generated report.
 * @property id Migration validation result identifier
 * @property reportUrl The url of the report.
 */
public data class MigrationReportResultResponse(
    public val id: String? = null,
    public val reportUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrationReportResultResponse):
            MigrationReportResultResponse = MigrationReportResultResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            reportUrl = javaType.reportUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
