@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Describes how an individual MongoDB database should be migrated
 * @property collections The collections on the source database to migrate to the target. The keys are the unqualified names of the collections.
 * @property targetRUs The RUs that should be configured on a CosmosDB target, or null to use the default, or 0 if throughput should not be provisioned for the database. This has no effect on non-CosmosDB targets.
 */
public data class MongoDbDatabaseSettingsResponse(
    public val collections: Map<String, MongoDbCollectionSettingsResponse>,
    public val targetRUs: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbDatabaseSettingsResponse):
            MongoDbDatabaseSettingsResponse = MongoDbDatabaseSettingsResponse(
            collections = javaType.collections().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbCollectionSettingsResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            targetRUs = javaType.targetRUs().map({ args0 -> args0 }).orElse(null),
        )
    }
}
