@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes an error or warning that occurred during a MongoDB migration
 * @property code The non-localized, machine-readable code that describes the error or warning
 * @property count The number of times the error or warning has occurred
 * @property message The localized, human-readable message that describes the error or warning
 * @property type The type of error or warning
 */
public data class MongoDbErrorResponse(
    public val code: String? = null,
    public val count: Int? = null,
    public val message: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbErrorResponse):
            MongoDbErrorResponse = MongoDbErrorResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
