@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Any
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property additionalProperties  Unmatched properties from the message are deserialized in this collection.
 * @property availableMemoryInMB Available memory (MB) on the integration runtime node.
 * @property concurrentJobsLimit Maximum concurrent jobs on the integration runtime node.
 * @property concurrentJobsRunning The number of jobs currently running on the integration runtime node.
 * @property cpuUtilization CPU percentage on the integration runtime node.
 * @property maxConcurrentJobs The maximum concurrent jobs in this integration runtime.
 * @property nodeName Name of the integration runtime node.
 * @property receivedBytes Received bytes on the integration runtime node.
 * @property sentBytes Sent bytes on the integration runtime node.
 */
public data class NodeMonitoringDataResponse(
    public val additionalProperties: Map<String, Any>,
    public val availableMemoryInMB: Int,
    public val concurrentJobsLimit: Int,
    public val concurrentJobsRunning: Int,
    public val cpuUtilization: Int,
    public val maxConcurrentJobs: Int,
    public val nodeName: String,
    public val receivedBytes: Double,
    public val sentBytes: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.NodeMonitoringDataResponse):
            NodeMonitoringDataResponse = NodeMonitoringDataResponse(
            additionalProperties = javaType.additionalProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            availableMemoryInMB = javaType.availableMemoryInMB(),
            concurrentJobsLimit = javaType.concurrentJobsLimit(),
            concurrentJobsRunning = javaType.concurrentJobsRunning(),
            cpuUtilization = javaType.cpuUtilization(),
            maxConcurrentJobs = javaType.maxConcurrentJobs(),
            nodeName = javaType.nodeName(),
            receivedBytes = javaType.receivedBytes(),
            sentBytes = javaType.sentBytes(),
        )
    }
}
