@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information of orphaned users on the SQL server database.
 * @property databaseName Parent database of the user
 * @property name Name of the orphaned user
 */
public data class OrphanedUserInfoResponse(
    public val databaseName: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.OrphanedUserInfoResponse):
            OrphanedUserInfoResponse = OrphanedUserInfoResponse(
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
