@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * An Azure SKU instance
 * @property capacity The capacity of the SKU, if it supports scaling
 * @property family The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
 * @property name The unique name of the SKU, such as 'P3'
 * @property size The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
 * @property tier The tier of the SKU, such as 'Basic', 'General Purpose', or 'Business Critical'
 */
public data class ServiceSkuResponse(
    public val capacity: Int? = null,
    public val family: String? = null,
    public val name: String? = null,
    public val size: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ServiceSkuResponse):
            ServiceSkuResponse = ServiceSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
