@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SSIS migration info with SSIS store type, overwrite policy.
 * @property environmentOverwriteOption The overwrite option for the SSIS environment migration
 * @property projectOverwriteOption The overwrite option for the SSIS project migration
 * @property ssisStoreType The SSIS store type of source, only SSIS catalog is supported now in DMS
 */
public data class SsisMigrationInfoResponse(
    public val environmentOverwriteOption: String? = null,
    public val projectOverwriteOption: String? = null,
    public val ssisStoreType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.SsisMigrationInfoResponse):
            SsisMigrationInfoResponse = SsisMigrationInfoResponse(
            environmentOverwriteOption = javaType.environmentOverwriteOption().map({ args0 ->
                args0
            }).orElse(null),
            projectOverwriteOption = javaType.projectOverwriteOption().map({ args0 -> args0 }).orElse(null),
            ssisStoreType = javaType.ssisStoreType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
