@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for task that validates migration input for SQL sync migrations
 * @property id Database identifier
 * @property name Name of database
 * @property validationErrors Errors associated with a selected database object
 */
public data class ValidateSyncMigrationInputSqlServerTaskOutputResponse(
    public val id: String,
    public val name: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ValidateSyncMigrationInputSqlServerTaskOutputResponse):
            ValidateSyncMigrationInputSqlServerTaskOutputResponse =
            ValidateSyncMigrationInputSqlServerTaskOutputResponse(
                id = javaType.id(),
                name = javaType.name(),
                validationErrors = javaType.validationErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
