@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Wait statistics gathered during query batch execution
 * @property waitCount Total no. of waits
 * @property waitTimeMs Total wait time in millisecond(s)
 * @property waitType Type of the Wait
 */
public data class WaitStatisticsResponse(
    public val waitCount: Double? = null,
    public val waitTimeMs: Double? = null,
    public val waitType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.WaitStatisticsResponse):
            WaitStatisticsResponse = WaitStatisticsResponse(
            waitCount = javaType.waitCount().map({ args0 -> args0 }).orElse(null),
            waitTimeMs = javaType.waitTimeMs().map({ args0 -> args0 }).orElse(null),
            waitType = javaType.waitType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
