@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin

import com.pulumi.azurenative.dataprotection.kotlin.outputs.ResourceGuardResponse
import com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.dataprotection.kotlin.outputs.ResourceGuardResponse.Companion.toKotlin as resourceGuardResponseToKotlin
import com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ResourceGuard].
 */
@PulumiTagMarker
public class ResourceGuardResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceGuardArgs = ResourceGuardArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceGuardArgsBuilder.() -> Unit) {
        val builder = ResourceGuardArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceGuard {
        val builtJavaResource =
            com.pulumi.azurenative.dataprotection.ResourceGuard(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResourceGuard(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-10-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01-preview, 2023-11-01, 2023-12-01, 2024-02-01-preview, 2024-03-01.
 * ## Example Usage
 * ### Create ResourceGuard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceGuard = new AzureNative.DataProtection.ResourceGuard("resourceGuard", new()
 *     {
 *         Location = "WestUS",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ResourceGuardsName = "swaggerExample",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dataprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dataprotection.NewResourceGuard(ctx, "resourceGuard", &dataprotection.ResourceGuardArgs{
 * 			Location:           pulumi.String("WestUS"),
 * 			ResourceGroupName:  pulumi.String("SampleResourceGroup"),
 * 			ResourceGuardsName: pulumi.String("swaggerExample"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dataprotection.ResourceGuard;
 * import com.pulumi.azurenative.dataprotection.ResourceGuardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceGuard = new ResourceGuard("resourceGuard", ResourceGuardArgs.builder()
 *             .location("WestUS")
 *             .resourceGroupName("SampleResourceGroup")
 *             .resourceGuardsName("swaggerExample")
 *             .tags(Map.of("key1", "val1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dataprotection:ResourceGuard VaultGuardTestNew /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}
 * ```
 */
public class ResourceGuard internal constructor(
    override val javaResource: com.pulumi.azurenative.dataprotection.ResourceGuard,
) : KotlinCustomResource(javaResource, ResourceGuardMapper) {
    /**
     * Optional ETag.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name associated with the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ResourceGuardResource properties
     */
    public val properties: Output<ResourceGuardResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceGuardResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ResourceGuardMapper : ResourceMapper<ResourceGuard> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dataprotection.ResourceGuard::class == javaResource::class

    override fun map(javaResource: Resource): ResourceGuard = ResourceGuard(
        javaResource as
            com.pulumi.azurenative.dataprotection.ResourceGuard,
    )
}

/**
 * @see [ResourceGuard].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceGuard].
 */
public suspend fun resourceGuard(
    name: String,
    block: suspend ResourceGuardResourceBuilder.() -> Unit,
): ResourceGuard {
    val builder = ResourceGuardResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceGuard].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceGuard(name: String): ResourceGuard {
    val builder = ResourceGuardResourceBuilder()
    builder.name(name)
    return builder.build()
}
