@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the type of secret store
 */
public enum class SecretStoreType(
    public val javaValue: com.pulumi.azurenative.dataprotection.enums.SecretStoreType,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.enums.SecretStoreType> {
    Invalid(com.pulumi.azurenative.dataprotection.enums.SecretStoreType.Invalid),
    AzureKeyVault(com.pulumi.azurenative.dataprotection.enums.SecretStoreType.AzureKeyVault),
    ;

    override fun toJava(): com.pulumi.azurenative.dataprotection.enums.SecretStoreType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.enums.SecretStoreType):
            SecretStoreType = SecretStoreType.values().first { it.javaValue == javaType }
    }
}
