@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.AzureRetentionRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure retention rule
 * @property isDefault
 * @property lifecycles
 * @property name
 * @property objectType
 * Expected value is 'AzureRetentionRule'.
 */
public data class AzureRetentionRuleArgs(
    public val isDefault: Output<Boolean>? = null,
    public val lifecycles: Output<List<SourceLifeCycleArgs>>,
    public val name: Output<String>,
    public val objectType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.AzureRetentionRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.AzureRetentionRuleArgs =
        com.pulumi.azurenative.dataprotection.inputs.AzureRetentionRuleArgs.builder()
            .isDefault(isDefault?.applyValue({ args0 -> args0 }))
            .lifecycles(
                lifecycles.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .objectType(objectType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureRetentionRuleArgs].
 */
@PulumiTagMarker
public class AzureRetentionRuleArgsBuilder internal constructor() {
    private var isDefault: Output<Boolean>? = null

    private var lifecycles: Output<List<SourceLifeCycleArgs>>? = null

    private var name: Output<String>? = null

    private var objectType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("fqfbmhvsdqmpwbyd")
    public suspend fun isDefault(`value`: Output<Boolean>) {
        this.isDefault = value
    }

    /**
     * @param value
     */
    @JvmName("bwrrqnhlkowhnrxy")
    public suspend fun lifecycles(`value`: Output<List<SourceLifeCycleArgs>>) {
        this.lifecycles = value
    }

    @JvmName("vfbixtmqbtwiuwcq")
    public suspend fun lifecycles(vararg values: Output<SourceLifeCycleArgs>) {
        this.lifecycles = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("scgbfkakyqeuwubv")
    public suspend fun lifecycles(values: List<Output<SourceLifeCycleArgs>>) {
        this.lifecycles = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ebjryddsosohgevl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     * Expected value is 'AzureRetentionRule'.
     */
    @JvmName("crqsqlvxrvqbxjvx")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value
     */
    @JvmName("tsysfddgeehhxjsk")
    public suspend fun isDefault(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDefault = mapped
    }

    /**
     * @param value
     */
    @JvmName("woyspfyseldfywiv")
    public suspend fun lifecycles(`value`: List<SourceLifeCycleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycles = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lwvwwoeuyeyoauxp")
    public suspend fun lifecycles(argument: List<suspend SourceLifeCycleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SourceLifeCycleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecycles = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sghcksacgaqduyip")
    public suspend fun lifecycles(vararg argument: suspend SourceLifeCycleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SourceLifeCycleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecycles = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kfkpllugrpnpgoup")
    public suspend fun lifecycles(argument: suspend SourceLifeCycleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SourceLifeCycleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lifecycles = mapped
    }

    /**
     * @param values
     */
    @JvmName("hcvqjburbwjiveun")
    public suspend fun lifecycles(vararg values: SourceLifeCycleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycles = mapped
    }

    /**
     * @param value
     */
    @JvmName("laahhcdfidomgcyt")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     * Expected value is 'AzureRetentionRule'.
     */
    @JvmName("bpxoowucvnxulalt")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    internal fun build(): AzureRetentionRuleArgs = AzureRetentionRuleArgs(
        isDefault = isDefault,
        lifecycles = lifecycles ?: throw PulumiNullFieldException("lifecycles"),
        name = name ?: throw PulumiNullFieldException("name"),
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
    )
}
