@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.BackupScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Schedule for backup
 * @property repeatingTimeIntervals ISO 8601 repeating time interval format
 * @property timeZone Time zone for a schedule. Example: Pacific Standard Time
 */
public data class BackupScheduleArgs(
    public val repeatingTimeIntervals: Output<List<String>>,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.BackupScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.BackupScheduleArgs =
        com.pulumi.azurenative.dataprotection.inputs.BackupScheduleArgs.builder()
            .repeatingTimeIntervals(repeatingTimeIntervals.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupScheduleArgs].
 */
@PulumiTagMarker
public class BackupScheduleArgsBuilder internal constructor() {
    private var repeatingTimeIntervals: Output<List<String>>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value ISO 8601 repeating time interval format
     */
    @JvmName("homsfbnfrpfiwmon")
    public suspend fun repeatingTimeIntervals(`value`: Output<List<String>>) {
        this.repeatingTimeIntervals = value
    }

    @JvmName("ofkqodtuhwhnkfcs")
    public suspend fun repeatingTimeIntervals(vararg values: Output<String>) {
        this.repeatingTimeIntervals = Output.all(values.asList())
    }

    /**
     * @param values ISO 8601 repeating time interval format
     */
    @JvmName("eosybxwkdlpsswrj")
    public suspend fun repeatingTimeIntervals(values: List<Output<String>>) {
        this.repeatingTimeIntervals = Output.all(values)
    }

    /**
     * @param value Time zone for a schedule. Example: Pacific Standard Time
     */
    @JvmName("ufcdmoklaaglqpnk")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value ISO 8601 repeating time interval format
     */
    @JvmName("pupeclflfyrjhygc")
    public suspend fun repeatingTimeIntervals(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repeatingTimeIntervals = mapped
    }

    /**
     * @param values ISO 8601 repeating time interval format
     */
    @JvmName("keyvveqbbbhmtrkt")
    public suspend fun repeatingTimeIntervals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repeatingTimeIntervals = mapped
    }

    /**
     * @param value Time zone for a schedule. Example: Pacific Standard Time
     */
    @JvmName("hlaltheubktdlhou")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): BackupScheduleArgs = BackupScheduleArgs(
        repeatingTimeIntervals = repeatingTimeIntervals ?: throw
            PulumiNullFieldException("repeatingTimeIntervals"),
        timeZone = timeZone,
    )
}
