@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.PolicyInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Policy Info in backupInstance
 * @property policyId
 * @property policyParameters Policy parameters for the backup instance
 */
public data class PolicyInfoArgs(
    public val policyId: Output<String>,
    public val policyParameters: Output<PolicyParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.PolicyInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.PolicyInfoArgs =
        com.pulumi.azurenative.dataprotection.inputs.PolicyInfoArgs.builder()
            .policyId(policyId.applyValue({ args0 -> args0 }))
            .policyParameters(
                policyParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicyInfoArgs].
 */
@PulumiTagMarker
public class PolicyInfoArgsBuilder internal constructor() {
    private var policyId: Output<String>? = null

    private var policyParameters: Output<PolicyParametersArgs>? = null

    /**
     * @param value
     */
    @JvmName("osiosggiauoeabsu")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value Policy parameters for the backup instance
     */
    @JvmName("semqjrajjxxgxnaw")
    public suspend fun policyParameters(`value`: Output<PolicyParametersArgs>) {
        this.policyParameters = value
    }

    /**
     * @param value
     */
    @JvmName("fdvuvcfdwnoeeaso")
    public suspend fun policyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Policy parameters for the backup instance
     */
    @JvmName("cjdsjugxjvtwjksq")
    public suspend fun policyParameters(`value`: PolicyParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyParameters = mapped
    }

    /**
     * @param argument Policy parameters for the backup instance
     */
    @JvmName("jcojonxdwbjjxtxq")
    public suspend fun policyParameters(argument: suspend PolicyParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policyParameters = mapped
    }

    internal fun build(): PolicyInfoArgs = PolicyInfoArgs(
        policyId = policyId ?: throw PulumiNullFieldException("policyId"),
        policyParameters = policyParameters,
    )
}
