@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.ScheduleBasedBackupCriteriaArgs.builder
import com.pulumi.azurenative.dataprotection.kotlin.enums.AbsoluteMarker
import com.pulumi.azurenative.dataprotection.kotlin.enums.DayOfWeek
import com.pulumi.azurenative.dataprotection.kotlin.enums.Month
import com.pulumi.azurenative.dataprotection.kotlin.enums.WeekNumber
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Schedule based backup criteria
 * @property absoluteCriteria it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth"
 * and should be part of AbsoluteMarker enum
 * @property daysOfMonth This is day of the month from 1 to 28 other wise last of month
 * @property daysOfTheWeek It should be Sunday/Monday/T..../Saturday
 * @property monthsOfYear It should be January/February/....../December
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'ScheduleBasedBackupCriteria'.
 * @property scheduleTimes List of schedule times for backup
 * @property weeksOfTheMonth It should be First/Second/Third/Fourth/Last
 */
public data class ScheduleBasedBackupCriteriaArgs(
    public val absoluteCriteria: Output<List<Either<String, AbsoluteMarker>>>? = null,
    public val daysOfMonth: Output<List<DayArgs>>? = null,
    public val daysOfTheWeek: Output<List<Either<String, DayOfWeek>>>? = null,
    public val monthsOfYear: Output<List<Either<String, Month>>>? = null,
    public val objectType: Output<String>,
    public val scheduleTimes: Output<List<String>>? = null,
    public val weeksOfTheMonth: Output<List<Either<String, WeekNumber>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.ScheduleBasedBackupCriteriaArgs> {
    override fun toJava():
        com.pulumi.azurenative.dataprotection.inputs.ScheduleBasedBackupCriteriaArgs =
        com.pulumi.azurenative.dataprotection.inputs.ScheduleBasedBackupCriteriaArgs.builder()
            .absoluteCriteria(
                absoluteCriteria?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .daysOfMonth(
                daysOfMonth?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .daysOfTheWeek(
                daysOfTheWeek?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .monthsOfYear(
                monthsOfYear?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .objectType(objectType.applyValue({ args0 -> args0 }))
            .scheduleTimes(scheduleTimes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .weeksOfTheMonth(
                weeksOfTheMonth?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScheduleBasedBackupCriteriaArgs].
 */
@PulumiTagMarker
public class ScheduleBasedBackupCriteriaArgsBuilder internal constructor() {
    private var absoluteCriteria: Output<List<Either<String, AbsoluteMarker>>>? = null

    private var daysOfMonth: Output<List<DayArgs>>? = null

    private var daysOfTheWeek: Output<List<Either<String, DayOfWeek>>>? = null

    private var monthsOfYear: Output<List<Either<String, Month>>>? = null

    private var objectType: Output<String>? = null

    private var scheduleTimes: Output<List<String>>? = null

    private var weeksOfTheMonth: Output<List<Either<String, WeekNumber>>>? = null

    /**
     * @param value it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth"
     * and should be part of AbsoluteMarker enum
     */
    @JvmName("tdlyqhdtuvnqykxl")
    public suspend fun absoluteCriteria(`value`: Output<List<Either<String, AbsoluteMarker>>>) {
        this.absoluteCriteria = value
    }

    @JvmName("bljitfefpnbyixnb")
    public suspend fun absoluteCriteria(vararg values: Output<Either<String, AbsoluteMarker>>) {
        this.absoluteCriteria = Output.all(values.asList())
    }

    /**
     * @param values it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth"
     * and should be part of AbsoluteMarker enum
     */
    @JvmName("yiulfjohsmwjbjxg")
    public suspend fun absoluteCriteria(values: List<Output<Either<String, AbsoluteMarker>>>) {
        this.absoluteCriteria = Output.all(values)
    }

    /**
     * @param value This is day of the month from 1 to 28 other wise last of month
     */
    @JvmName("ewcysrquegspapqm")
    public suspend fun daysOfMonth(`value`: Output<List<DayArgs>>) {
        this.daysOfMonth = value
    }

    @JvmName("fqccyxdogukttuqs")
    public suspend fun daysOfMonth(vararg values: Output<DayArgs>) {
        this.daysOfMonth = Output.all(values.asList())
    }

    /**
     * @param values This is day of the month from 1 to 28 other wise last of month
     */
    @JvmName("jvqiaxhafdeflcsb")
    public suspend fun daysOfMonth(values: List<Output<DayArgs>>) {
        this.daysOfMonth = Output.all(values)
    }

    /**
     * @param value It should be Sunday/Monday/T..../Saturday
     */
    @JvmName("mlmjulemhulrwdul")
    public suspend fun daysOfTheWeek(`value`: Output<List<Either<String, DayOfWeek>>>) {
        this.daysOfTheWeek = value
    }

    @JvmName("yjupicmltooftfyc")
    public suspend fun daysOfTheWeek(vararg values: Output<Either<String, DayOfWeek>>) {
        this.daysOfTheWeek = Output.all(values.asList())
    }

    /**
     * @param values It should be Sunday/Monday/T..../Saturday
     */
    @JvmName("voloftmeggqkoywv")
    public suspend fun daysOfTheWeek(values: List<Output<Either<String, DayOfWeek>>>) {
        this.daysOfTheWeek = Output.all(values)
    }

    /**
     * @param value It should be January/February/....../December
     */
    @JvmName("yikvyuknxtbcalwv")
    public suspend fun monthsOfYear(`value`: Output<List<Either<String, Month>>>) {
        this.monthsOfYear = value
    }

    @JvmName("gynbtmdcwitdrrqx")
    public suspend fun monthsOfYear(vararg values: Output<Either<String, Month>>) {
        this.monthsOfYear = Output.all(values.asList())
    }

    /**
     * @param values It should be January/February/....../December
     */
    @JvmName("lgbmddmqhccticcq")
    public suspend fun monthsOfYear(values: List<Output<Either<String, Month>>>) {
        this.monthsOfYear = Output.all(values)
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'ScheduleBasedBackupCriteria'.
     */
    @JvmName("alowxcukbbkusngl")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value List of schedule times for backup
     */
    @JvmName("ruytknvaqgmdwuci")
    public suspend fun scheduleTimes(`value`: Output<List<String>>) {
        this.scheduleTimes = value
    }

    @JvmName("xyswxrclbosvavqr")
    public suspend fun scheduleTimes(vararg values: Output<String>) {
        this.scheduleTimes = Output.all(values.asList())
    }

    /**
     * @param values List of schedule times for backup
     */
    @JvmName("reghbrrjuojrffhk")
    public suspend fun scheduleTimes(values: List<Output<String>>) {
        this.scheduleTimes = Output.all(values)
    }

    /**
     * @param value It should be First/Second/Third/Fourth/Last
     */
    @JvmName("xujxidfqkxcjvgns")
    public suspend fun weeksOfTheMonth(`value`: Output<List<Either<String, WeekNumber>>>) {
        this.weeksOfTheMonth = value
    }

    @JvmName("ccycywvlcdjslpxd")
    public suspend fun weeksOfTheMonth(vararg values: Output<Either<String, WeekNumber>>) {
        this.weeksOfTheMonth = Output.all(values.asList())
    }

    /**
     * @param values It should be First/Second/Third/Fourth/Last
     */
    @JvmName("dxrnecpxlvmsmvpd")
    public suspend fun weeksOfTheMonth(values: List<Output<Either<String, WeekNumber>>>) {
        this.weeksOfTheMonth = Output.all(values)
    }

    /**
     * @param value it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth"
     * and should be part of AbsoluteMarker enum
     */
    @JvmName("fkbnasosedlpydpa")
    public suspend fun absoluteCriteria(`value`: List<Either<String, AbsoluteMarker>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.absoluteCriteria = mapped
    }

    /**
     * @param values it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth"
     * and should be part of AbsoluteMarker enum
     */
    @JvmName("gevjxxsephnrkqaj")
    public suspend fun absoluteCriteria(vararg values: Either<String, AbsoluteMarker>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.absoluteCriteria = mapped
    }

    /**
     * @param value This is day of the month from 1 to 28 other wise last of month
     */
    @JvmName("dkonoctshhenwtgq")
    public suspend fun daysOfMonth(`value`: List<DayArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfMonth = mapped
    }

    /**
     * @param argument This is day of the month from 1 to 28 other wise last of month
     */
    @JvmName("evfwdwgcdhpurnxa")
    public suspend fun daysOfMonth(argument: List<suspend DayArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DayArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.daysOfMonth = mapped
    }

    /**
     * @param argument This is day of the month from 1 to 28 other wise last of month
     */
    @JvmName("fiwcmtyllbyeesei")
    public suspend fun daysOfMonth(vararg argument: suspend DayArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DayArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.daysOfMonth = mapped
    }

    /**
     * @param argument This is day of the month from 1 to 28 other wise last of month
     */
    @JvmName("wppmbhntanqkfcai")
    public suspend fun daysOfMonth(argument: suspend DayArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DayArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.daysOfMonth = mapped
    }

    /**
     * @param values This is day of the month from 1 to 28 other wise last of month
     */
    @JvmName("alouncgqnmikdssa")
    public suspend fun daysOfMonth(vararg values: DayArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfMonth = mapped
    }

    /**
     * @param value It should be Sunday/Monday/T..../Saturday
     */
    @JvmName("mocjbavhnriijqku")
    public suspend fun daysOfTheWeek(`value`: List<Either<String, DayOfWeek>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfTheWeek = mapped
    }

    /**
     * @param values It should be Sunday/Monday/T..../Saturday
     */
    @JvmName("nvvdatqpfeyunrrh")
    public suspend fun daysOfTheWeek(vararg values: Either<String, DayOfWeek>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfTheWeek = mapped
    }

    /**
     * @param value It should be January/February/....../December
     */
    @JvmName("wswgouruaejvvlhh")
    public suspend fun monthsOfYear(`value`: List<Either<String, Month>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthsOfYear = mapped
    }

    /**
     * @param values It should be January/February/....../December
     */
    @JvmName("rsgmdjiddyeydgff")
    public suspend fun monthsOfYear(vararg values: Either<String, Month>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monthsOfYear = mapped
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'ScheduleBasedBackupCriteria'.
     */
    @JvmName("nedontkxiowtbklh")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value List of schedule times for backup
     */
    @JvmName("esxtvbypjmkgtxlk")
    public suspend fun scheduleTimes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleTimes = mapped
    }

    /**
     * @param values List of schedule times for backup
     */
    @JvmName("whvdpefeidimxfcb")
    public suspend fun scheduleTimes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleTimes = mapped
    }

    /**
     * @param value It should be First/Second/Third/Fourth/Last
     */
    @JvmName("aksgeyrcdlvoucli")
    public suspend fun weeksOfTheMonth(`value`: List<Either<String, WeekNumber>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeksOfTheMonth = mapped
    }

    /**
     * @param values It should be First/Second/Third/Fourth/Last
     */
    @JvmName("axfqqjhdgmmrguec")
    public suspend fun weeksOfTheMonth(vararg values: Either<String, WeekNumber>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weeksOfTheMonth = mapped
    }

    internal fun build(): ScheduleBasedBackupCriteriaArgs = ScheduleBasedBackupCriteriaArgs(
        absoluteCriteria = absoluteCriteria,
        daysOfMonth = daysOfMonth,
        daysOfTheWeek = daysOfTheWeek,
        monthsOfYear = monthsOfYear,
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
        scheduleTimes = scheduleTimes,
        weeksOfTheMonth = weeksOfTheMonth,
    )
}
